//
//  GSApplicationPluginProtocol.h
//  Glyphs
//
//  Created by Martin Winter on 18/12/2018.
//  Copyright © 2018 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSDocument;

NS_ASSUME_NONNULL_BEGIN

@protocol GSApplicationPluginProtocol <NSObject>

- (NSArray *)fontDocuments;

- (nullable GSDocument *)currentFontDocument;

- (void)presentErrors:(NSDictionary *)errors;

- (void)presentErrorDelayed:(NSError *)error;
#ifndef GLYPHS_LITE
- (NSString *)serialNumber;
#endif

@end

NS_ASSUME_NONNULL_END
